//******************************************************************************
//  
//  TUTOR1: Example of two tasks work in parallel 
// 
//******************************************************************************


#include <osa.h>

//******************************************************************************
//  Global variables
//******************************************************************************

char m_cCounter1;
char m_cCounter2;

//******************************************************************************
//  Tasks
//******************************************************************************

void Task_T1 (void)
{
    m_cCounter1 = 0;
    for (;;)
    {
        OS_Yield();              // Switch context (return to scheduler)
        m_cCounter1++;
    }
}

//------------------------------------------------------------------------------

void Task_T2 (void)
{
    m_cCounter2 = 0;
    for (;;)
    {
        OS_Yield();              // Switch context (return to scheduler)
        m_cCounter2++;
    }
}

//******************************************************************************
//  main
//******************************************************************************

void main (void)
{
    OS_Init();                  // System init

    OS_Task_Create(0, Task_T1); // Tell to OS that Task_T1 and Task_T2 will
    OS_Task_Create(1, Task_T2); // be called by scheduler

    OS_Run();                   // Run scheduler
}

//******************************************************************************
//  end of file
//******************************************************************************

