/*
 ************************************************************************************************
 *
 *  OSA cooperative RTOS for microcontrollers PIC, AVR and STM8
 *
 *  OSA is distributed under BSD license (see license.txt)
 *
 *  URL:            http://wiki.pic24.ru/doku.php/en/osa/ref/intro
 *
 *----------------------------------------------------------------------------------------------
 *
 *  File:           osa_ttimer.h
 *
 *  Programmer:     Timofeev Victor
 *                  osa@pic24.ru, testerplus@mail.ru
 *
 *  Description:    Services for Task Timers
 *
 *  History:        12.09.2010 -    File updated
 * 
 *                  25.10.2010  -   Definition of OS_Ttimer_Delay fixed
 *
 ************************************************************************************************
 */

/************************************************************************************************
 *                                                                                              *
 *                                    T A S K   T I M E R S                                     * 
 *                                                                                              *
 ************************************************************************************************/


//------------------------------------------------------------------------------
#ifdef OS_ENABLE_TTIMERS
//------------------------------------------------------------------------------


//******************************************************************************
//  VARIABLES
//******************************************************************************


//******************************************************************************
//  FUNCTION PROTOTYPES
//******************************************************************************


//******************************************************************************
//  MACROS
//******************************************************************************


void _OS_InitDelay(OS_TTIMER_TYPE Delay);



/************************************************************************/
/*                                                                      */
/* Delay current task                                                   */
/*                                                                      */
/************************************************************************/
#define OS_Delay(delaytime)                        \
    {                                              \
        _OS_InitDelay(delaytime);                  \
        OS_Yield();                                \
    }                                              \


#define OS_Ttimer_Delay(delaytime)   OS_Delay(delaytime)    /*101025*/

/************************************************************************/
// Run task timer for user purpose
/************************************************************************/

#define OS_Ttimer_Run(delaytime)                    \
    {                                               \
        _OS_InitDelay(delaytime);                   \
        _OS_bTaskCanContinue = 1;                   \
    }                                               \

/************************************************************************/
// Check task timer for timeout
/************************************************************************/

#define OS_Ttimer_Check()            !_OS_CurTask->State.bDelay

/************************************************************************/
// Check task timer is run
/************************************************************************/

#define OS_Ttimer_IsRun()            _OS_CurTask->State.bDelay


/************************************************************************/
// Get task timer's value
/************************************************************************/

#define OS_Ttimer_Get()              (-_OS_CurTask->Timer)

/************************************************************************/
// Wait for task timer will overflow
/************************************************************************/

#define OS_Ttimer_Wait()             OS_Wait(OS_Ttimer_Check())


/************************************************************************/
// Break timer and clear counter
/************************************************************************/

#define OS_Ttimer_Break()                           \
    _OS_TASK_ATOMIC_WRITE_A(                        \
        _OS_CurTask->State.bDelay = 0;              \
        _OS_CurTask->Timer        = 0;              \
    )





//------------------------------------------------------------------------------
#endif          // OS_ENABLE_TTIMERS
//------------------------------------------------------------------------------


//******************************************************************************
//  END OF FILE
//******************************************************************************

