#include <htc.h>
#include <osa.h>



//------------------------------------------------------------------------------
//   :
//   -  RC-
//   -  WDT
//   -   
//   -   
//------------------------------------------------------------------------------

__CONFIG(INTIO & WDTDIS & PWRTEN & MCLRDIS & LVPDIS & UNPROTECT & BORDIS 
               & IESODIS & FCMDIS & DEBUGDIS);


//------------------------------------------------------------------------------
//      
//------------------------------------------------------------------------------

#define PIN_LED1    RD0
#define PIN_LED2    RD1
#define PIN_LED3    RD2

//------------------------------------------------------------------------------
//   :
//  -  = 4, 
//  -  = 1,
//  -   = 250
// 
//     = 4 .
// 
//      TMR2  
//   4 * 1 * 250 * Tcyc = 1 ms
// 
//------------------------------------------------------------------------------

#define PR2_CONST       250-1
#define TMR2_PRS        1                           // prs = 4
#define TMR2_POST       0                           // post = 1
#define T2CON_CONST     (TMR2_POST<<3) | TMR2_PRS


//******************************************************************************
//  .   
//******************************************************************************

void interrupt isr (void)
{
    if (TMR2IF)
    {   
        OS_Timer();
        TMR2IF = 0;
    }
}



//******************************************************************************
//  -
//******************************************************************************

void Task_LED1 (void)
{
    for (;;)
    {
        OS_Bsem_Wait(BS_FLASH);  //  
        PIN_LED1 ^= 1;           //    
    }
}

//-----------------------------------------------------------------------------

void Task_LED2 (void)
{
    for (;;)
    {
        OS_Bsem_Wait(BS_FLASH);  //  
        PIN_LED2 ^= 1;           //    
    }
}

//-----------------------------------------------------------------------------

void Task_LED3 (void)
{
    for (;;)
    {
        OS_Bsem_Wait(BS_FLASH);  //  
        PIN_LED3 ^= 1;           //    
    }
}

//-----------------------------------------------------------------------------

void Task_Signal (void)
{
    for (;;)
    {
        OS_Bsem_Set(BS_FLASH);
        OS_Delay(200);
    }
}

//******************************************************************************
//   
//******************************************************************************

void init (void)
{
    //------------------------------------------------------------------------------
    //    I/O
    //------------------------------------------------------------------------------

    PORTA = 0;
    PORTB = 0;
    PORTC = 0;
    PORTD = 0;

    TRISA = 0;
    TRISB = 0;
    TRISC = 0;
    TRISD = 0;

    //------------------------------------------------------------------------------
    //    2
    //------------------------------------------------------------------------------

    PR2 = PR2_CONST;
    T2CON = T2CON_CONST | 0x04;
                                        
    //------------------------------------------------------------------------------
    //   
    //------------------------------------------------------------------------------

    PIR1 = 0;
    PIR2 = 0;
    INTCON = 0;

    TMR2IE = 1;         //    TMR2
    PEIE = 1;           //   
                        //      
                        //    
                        //    main()

}

//******************************************************************************
//  main
//******************************************************************************

void main (void)
{
    //  
    init();

    //  
    OS_Init();

    //  
    OS_Task_Create(3, Task_Signal);
    OS_Task_Create(3, Task_LED1);
    OS_Task_Create(3, Task_LED2);
    OS_Task_Create(3, Task_LED3);

    //  
    OS_EI();

    //  
    OS_Run();
}



