/*
 ************************************************************************************************
 *
 *  OSA cooperative RTOS for microcontrollers PIC, AVR and STM8
 *
 *  OSA is distributed under BSD license (see license.txt)
 *
 *  URL:            http://wiki.pic24.ru/doku.php/en/osa/ref/intro
 *
 *----------------------------------------------------------------------------------------------
 *
 *  File:           osa_include.h
 *
 *  Programmer:     Timofeev Victor
 *                  osa@pic24.ru, testerplus@mail.ru
 *
 *  Description:    Include proc specific file
 *                  This file directly included in osa.h
 *
 *  History:        19.09.2010 -    File updated
 *
 ************************************************************************************************
 */


//------------------------------------------------------------------------------
#if defined(__OSA_PIC18_HTPICC__)               // HT-PICC18
//------------------------------------------------------------------------------

    #include <port\pic18\osa_pic18_htpicc.h>

//------------------------------------------------------------------------------
#elif defined(__OSA_PIC18_MPLABC__)             // MPLAB C18
//------------------------------------------------------------------------------

    #include <port\pic18\osa_pic18_mplabc.h>          

//------------------------------------------------------------------------------
#elif defined(__OSA_PIC18_MPLABC_EXT__)         // MPLAB C18 for extended mode 
//------------------------------------------------------------------------------

    #include <port\pic18\osa_pic18_mplabc_ext.h>       

//------------------------------------------------------------------------------
#elif defined(__OSA_PIC24_MPLABC__)             // MPLAB C30
//------------------------------------------------------------------------------

    #include <port\pic24\osa_pic24_mplabc.h>          

//------------------------------------------------------------------------------
#elif defined(__OSA_PIC16_CCS__)                // CCS-PICC (for PIC16 only)
//------------------------------------------------------------------------------

    #include <port\pic16\osa_pic16_ccs.h>          

//------------------------------------------------------------------------------
#elif defined(__OSA_PIC18_CCS__)                // CCS-PICC (for PIC18 only)
//------------------------------------------------------------------------------

    #include <port\pic18\osa_pic18_ccs.h>          

//------------------------------------------------------------------------------
#elif defined(__OSA_PIC12_HTPICC__)             // HT_PICC for 12-bit PICs
//------------------------------------------------------------------------------

    #include <port\pic12\osa_pic12_htpicc.h>         

//------------------------------------------------------------------------------
#elif defined(__OSA_PIC16_HTPICC__)             // HT_PICC
//------------------------------------------------------------------------------

    #include <port\pic16\osa_pic16_htpicc.h>         

//------------------------------------------------------------------------------
#elif defined(__OSA_PIC16E_HTPICC_PRO__)        // HT_PICC_PRO for pic16f1xxx
//------------------------------------------------------------------------------

    #include <port\pic16\osa_pic16e_htpicc_pro.h>     

//------------------------------------------------------------------------------
#elif defined(__OSA_PIC16_MIKROC__)             // mikroC for PIC16
//------------------------------------------------------------------------------

    #include <port\pic16\osa_pic16_mikroc.h>       

//------------------------------------------------------------------------------
#elif defined(__OSA_PIC18_MIKROC__)             // mikroC for PIC18
//------------------------------------------------------------------------------

    #include <port\pic18\osa_pic18_mikroc.h>       

//------------------------------------------------------------------------------
#elif defined(__OSA_AVR_WINAVR__)               // WinAVR for Atmel AVR
//------------------------------------------------------------------------------

    #include <port\avr\osa_avr_winavr.h>        

//------------------------------------------------------------------------------
#elif defined(__OSA_AVR_IAR__)                  // IAR for Atmel AVR
//------------------------------------------------------------------------------

    #include <port\avr\osa_avr_iar.h>        

//------------------------------------------------------------------------------
#elif defined(__OSA_AVR_CODEVISION__)           // CodeVision for Atmel AVR
//------------------------------------------------------------------------------

    #include <port\avr\osa_avr_codevision.h>        

//------------------------------------------------------------------------------
#elif defined(__OSA_STM8_IAR__)                 // IAR for ST STM8
//------------------------------------------------------------------------------

    #include <port\stm8\osa_stm8_iar.h>      

//------------------------------------------------------------------------------
#elif defined(__OSA_STM8_COSMIC__)              // Cosmic for ST STM8
//------------------------------------------------------------------------------

    #include <port\stm8\osa_stm8_cosmic.h>      

//------------------------------------------------------------------------------
#elif defined(__OSA_STM8_RAISONANCE__)          // Raisonance for ST STM8
//------------------------------------------------------------------------------

    #include <port\stm8\osa_stm8_raisonance.h>      

//------------------------------------------------------------------------------
#else
//------------------------------------------------------------------------------

    #error "OSA error #1: Unknown compiler!"
            /* See manual section "Appendix/Error codes" for more information*/

//------------------------------------------------------------------------------
#endif
//------------------------------------------------------------------------------


//******************************************************************************
//  END OF FILE osa_include.h
//******************************************************************************

