/*
 ************************************************************************************************
 *
 *  OSA cooperative RTOS for microcontrollers PIC (Microchip) and 8-bit AVR (Atmel)
 *
 *  OSA is distributed under BSD license (see license.txt)
 *
 *  URL:            http://wiki.pic24.ru/doku.php/en/osa/ref/intro
 *                  http://picosa.narod.ru
 *
 *----------------------------------------------------------------------------------------------
 *
 *  File:           osa_csem.c
 *
 *  Programmer:     Timofeev Victor
 *                  osa@pic24.ru, testerplus@mail.ru
 *
 *  Description:    Functions for csems
 *
 *  History:        14.03.2010 -    File created
 *
 ************************************************************************************************
 */



/*
 ************************************************************************************************
 *                                                                                              *
 *                            C O U N T I N G    S E M A P H O R E S                            *
 *                                                                                              *
 ************************************************************************************************
 */
//------------------------------------------------------------------------------
#ifdef OS_ENABLE_CSEM
//------------------------------------------------------------------------------



/*
 ********************************************************************************
 *                                                                              *
 *  void _OS_Csem_Signal (OST_CSEM *pCSem)                                      *
 *                                                                              *
 *------------------------------------------------------------------------------*
 *                                                                              *
 *  Increase counting semaphore. Set EventError if csem is FF...                *
 *                                                                              *
 *                                                                              *
 *  parameters:     pCSem - pointer to counting semaphore                       *
 *                                                                              *
 *  on return:      OS_IsEventError()                                           *
 *                                                                              *
 *  Overloaded in:  "osa_pic16_htpicc.c"                                         *
 *                  "osa_pic18_htpicc.c"                                         *
 *                                                                              *
 ********************************************************************************
 */

//------------------------------------------------------------------------------
#if !defined(_OS_Csem_Signal_DEFINED)
//------------------------------------------------------------------------------

    void _OS_Csem_Signal (OST_CSEM *pCSem)
    {
        _OS_Flags.bEventError = 0;

        (*pCSem)++;
        if (!*pCSem)
        {
            (*pCSem) = (OST_CSEM) -1;
            _OS_Flags.bEventError = 1;
        }
    }

//------------------------------------------------------------------------------
#endif  // !defined(_OS_Csem_Signal_DEFINED
//------------------------------------------------------------------------------




//------------------------------------------------------------------------------
#if defined(OS_ENABLE_INT_CSEM) && !defined(_OS_Csem_Signal_I_DEFINED)
//------------------------------------------------------------------------------

    void _OS_Csem_Signal_I (OST_CSEM *pCSem)   
    {
        _OS_Flags.bEventError = 0;

        (*pCSem)++;
        if (!*pCSem)
        {
            (*pCSem) = (OST_CSEM) -1;
            _OS_Flags.bEventError = 1;
        }
    }
//------------------------------------------------------------------------------
#endif  // OS_ENABLE_INT_CSEM && !_OS_Csem_Signal_I_DEFINED
//------------------------------------------------------------------------------



//------------------------------------------------------------------------------
#endif  // OS_CSEM_ENABLE
//------------------------------------------------------------------------------








//******************************************************************************
//  END OF FILE osa_csem.c
//******************************************************************************

